/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.widgets;

import java.util.Objects;
import net.caffeinemc.mods.sodium.client.gui.ButtonTheme;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_5348;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jspecify.annotations.Nullable;

public class FlatButtonWidget
extends AbstractWidget
implements class_4068 {
    public static final ButtonTheme DEFAULT_THEME = new ButtonTheme(-1, -1, -5592406, -536870912, -1879048192, 0x40000000);
    private final Runnable action;
    private final boolean drawBackground;
    private final boolean drawFrame;
    private final boolean leftAlign;
    private final ButtonTheme theme;
    private final class_2561 label;
    private boolean selected;
    private boolean enabled = true;
    private boolean visible = true;

    public FlatButtonWidget(Dim2i dim, class_2561 label, Runnable action, boolean drawBackground, boolean drawFrame, boolean leftAlign, ButtonTheme theme) {
        super(dim);
        this.label = label;
        this.action = action;
        this.drawBackground = drawBackground;
        this.drawFrame = drawFrame;
        this.leftAlign = leftAlign;
        this.theme = theme;
    }

    public FlatButtonWidget(Dim2i dim, class_2561 label, Runnable action, boolean drawBackground, boolean leftAlign, ButtonTheme theme) {
        this(dim, label, action, drawBackground, !drawBackground, leftAlign, theme);
    }

    public FlatButtonWidget(Dim2i dim, class_2561 label, Runnable action, boolean drawBackground, boolean leftAlign) {
        this(dim, label, action, drawBackground, leftAlign, DEFAULT_THEME);
    }

    public FlatButtonWidget(Dim2i dim, class_2561 label, Runnable action, boolean drawBackground, boolean drawFrame, boolean leftAlign) {
        this(dim, label, action, drawBackground, drawFrame, leftAlign, DEFAULT_THEME);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        this.hovered = this.method_25405(mouseX, mouseY);
        int backgroundColor = this.enabled ? (this.hovered ? this.theme.bgHighlight : this.theme.bgDefault) : this.theme.bgInactive;
        int textColor = this.getTextColor();
        if (this.drawBackground) {
            this.drawRect(graphics, this.getX(), this.getY(), this.getLimitX(), this.getLimitY(), backgroundColor);
        }
        if (this.label != null) {
            int strWidth = this.font.method_27525((class_5348)this.label);
            int n = this.leftAlign ? this.getX() + 8 : this.getCenterX() - strWidth / 2;
            int n2 = this.getCenterY();
            Objects.requireNonNull(this.font);
            this.drawString(graphics, this.label, n, n2 - 9 / 2, textColor);
        }
        if (this.enabled && this.selected) {
            this.drawRect(graphics, this.getX(), this.getLimitY() - 1, this.getLimitX(), this.getLimitY(), -7019309);
        }
        if (this.drawFrame || this.enabled && this.method_25370()) {
            this.drawBorder(graphics, this.getX(), this.getY(), this.getLimitX(), this.getLimitY(), -2147418130);
        }
    }

    protected int getTextColor() {
        return this.enabled ? this.theme.themeLighter : this.theme.themeDarker;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (!this.enabled || !this.visible) {
            return false;
        }
        if (event.method_74245() == 0 && this.method_25405(event.comp_4798(), event.comp_4799())) {
            this.doAction();
            return true;
        }
        return false;
    }

    public boolean method_25404(class_11908 event) {
        if (!this.method_25370()) {
            return false;
        }
        if (event.method_74229()) {
            this.doAction();
            return true;
        }
        return false;
    }

    private void doAction() {
        this.action.run();
        this.playClickSound();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public @Nullable class_8016 method_48205(class_8023 event) {
        if (!this.enabled || !this.visible) {
            return null;
        }
        return super.method_48205(event);
    }

    public boolean isVisible() {
        return this.visible;
    }
}

